##########################################################
# Scheduled Script to Create Tasks to Monitor Backups    #
# Daniel Denault					 #
# 8/24/2017						 #
##########################################################

############################
## Setup Begin            ##
############################

	############################
	## User Credentials Setup ##
	############################
	
	$userID = 'BR-WIN2008-HMT1\admin'
	$userPassword = 'P@ssw0rd'

	############################
	## Backup Failure Setup   ##
	############################
	
	$taskFailureDescription='Backup Failure Email Task'
	$pathToXMLFailure='C:\winback\BackupFailureTask.xml'
	$pathToScriptFailure='-FILE C:\winback\WinFailure.ps1'

	############################
	## Backup Success Setup   ##
	############################

	$taskSuccessDescription='Backup Success Email Task'
	$pathToXMLSuccess='C:\winback\BackupSuccessTask.xml'
	$pathToScriptSuccess='-FILE C:\winback\WinSuccess.ps1'

	############################
	## Backup Warning Setup   ##
	############################

	$taskWarningDescription='Backup Warning Email Task'
	$pathToXMLWarning='C:\winback\BackupWarningTask.xml'
	$pathToScriptWarning='-FILE C:\winback\WinWarning.ps1'

############################
## Setup End              ##
############################

############################
## Script Begin ## 
############################

    $tmpFileFailure = "$pathToXMLFailure.tmp"
    $tmpFileSuccess = "$pathToXMLSuccess.tmp"
    $tmpFileWarning = "$pathToXMLWarning.tmp"

    Copy-Item $pathToXMLFailure $tmpFileFailure
    Copy-Item $pathToXMLSuccess $tmpFileSuccess
    Copy-Item $pathToXMLWarning $tmpFileWarning 

    (Get-Content $tmpFileFailure) -replace '#replaceValuePath' , $pathToScriptFailure -replace '#replaceValueAuthor' , $userID | Set-Content $tmpFileFailure
    (Get-Content $tmpFileSuccess) -replace '#replaceValuePath' , $pathToScriptSuccess -replace '#replaceValueAuthor' , $userID | Set-Content $tmpFileSuccess
    (Get-Content $tmpFileWarning) -replace '#replaceValuePath' , $pathToScriptWarning -replace '#replaceValueAuthor' , $userID | Set-Content $tmpFileWarning

	$fileContents = ( get-content $tmpFileFailure ) -replace '#replaceValuePath' , $pathToScriptFailure -replace '#replaceValueAuthor' , $userID

	schtasks /Create /S $env:computername /TN $taskFailureDescription /XML $tmpFileFailure /ru $userID /rp $userPassword 
		
	$fileContents = ( get-content $tmpFileSuccess ) -replace '#replaceValuePath' , $pathToScriptSuccess -replace '#replaceValueAuthor' , $userID

	schtasks /Create /S $env:computername /TN $taskSuccessDescription /XML $tmpFileSuccess /ru $userID /rp $userPassword 
		
	$fileContents = ( get-content $tmpFileWarning ) -replace '#replaceValuePath' , $pathToScriptWarning -replace '#replaceValueAuthor' , $userID

	schtasks /Create /S $env:computername /TN $taskWarningDescription /XML $tmpFileWarning /ru $userID /rp $userPassword 
	
	Remove-Item $tmpFileFailure 
	Remove-Item $tmpFileSuccess 
	Remove-Item $tmpFileWarning 

	#Remove-Item $pathToXMLFailure
	#Remove-Item $pathToXMLSuccess
	#Remove-Item $pathToXMLWarning


############################
## Script End ## 
############################
